unit Unit1;

//     ,
//     .

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

// ========================================================
//   
// Queue     
// Head      
// Tail      
// Element   
// Current   
// Next      
// Previous  

type TQueueRec = record
//    (ver. 1.0)
 QEKey   : longword;  //    (Inc only)
 QECount : longword;  //    
 ptHead  : pointer;   //   
 ptTail  : pointer;   //   
 ptCurr  : pointer;   //   
end;

//    (ver. 1.0)
type TQElementRec = record
//    (ver. 1.0)
 ptNext : pointer;    //   
 ptPrev : pointer;    //   
 Num    : word;       //   
 ptObj  : pointer;    //    
end;

type
  TptTQueueRec    = ^TQueueRec;     //  
  TptTQElementRec = ^TQElementRec;  //  

type
  TForm1 = class(TForm)
    Bevel1: TBevel;
    StaticText2: TStaticText;
    bttToBegin: TButton;
    bttPrev: TButton;
    bttNext: TButton;
    bttToEnd: TButton;
    bttAdd: TButton;
    bttDel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    StaticText3: TStaticText;
    procedure bttAddClick(Sender: TObject);
    procedure bttNextClick(Sender: TObject);
    procedure bttPrevClick(Sender: TObject);
    procedure bttToBeginClick(Sender: TObject);
    procedure bttToEndClick(Sender: TObject);
    procedure bttDelClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;
// ========================================================

var
  Form1 : TForm1;
// ========================================================
implementation
{$R *.dfm}
// ========================================================

var QueueRec    : TQueueRec;      //  

// ========================================================
//    ()
// ========================================================
// --------------------------------------------------------
//     
function GetQueue() : pointer;
var ptTQueueRec : TptTQueueRec;
begin
   ptTQueueRec := Addr(QueueRec);
   Result := ptTQueueRec;
end;

// --------------------------------------------------------
//       
procedure InsertQElement
  ( ptQueue : TptTQueueRec;    //    
    Cmd     : char;            //  'H' -   head, 'T'  tail 
    ptQEnew : TptTQElementRec  //     
  );
var ptQE    : TptTQElementRec;
begin
 // ,    
 if (ptQueue^.ptHead = nil) and (ptQueue^.ptTail = nil)
 then begin
   // INSERT   
   ptQueue^.ptHead := ptQEnew;
   ptQueue^.ptTail := ptQEnew;
 end
 else begin
   // INSERT    
   case UpCase(Cmd) of
   'H': begin
       //      
       ptQE := ptQueue^.ptHead;    //     
       ptQE^.ptPrev := ptQEnew;    //      
       ptQEnew^.ptNext := ptQE;    //      
       ptQueue^.ptHead := ptQEnew; //      
       end;
   'T': begin
       //      
       ptQE := ptQueue^.ptTail;    //     
       ptQE^.ptNext := ptQEnew;    //      
       ptQEnew^.ptPrev := ptQE;    //      
       ptQueue^.ptTail := ptQEnew; //      
       end;
   end; // case
 end;
 Inc(ptQueue^.QEKey);              // +1    
 Inc(ptQueue^.QECount);            // +1     
 ptQEnew^.Num := ptQueue^.QEKey;  //    
 ptQueue^.ptCurr := ptQEnew;       //  INSERT   
end;

// --------------------------------------------------------
//    
procedure AddNewQElement(ptQueue : TptTQueueRec; Cmd : char);
var   ptQEnew : TptTQElementRec;
begin
   try
     New(ptQEnew); //       
     Fillchar(ptQEnew^, SizeOF(ptQEnew^),#0);  //  
     InsertQElement ( ptQueue,Cmd,ptQEnew);    //   
    except
      ShowMessage('      ');
   end;
end;

// --------------------------------------------------------
//       
procedure AddQElementOld(ptQueue : TptTQueueRec);
var   ptWE   : TptTQElementRec;
      ptNE   : TptTQElementRec;
begin
   try
     New(ptWE); //     
     ptWE^.ptNext:=nil;
     ptWE^.ptPrev:=nil;
     //     
     if (ptQueue^.ptHead = NIL) and (ptQueue^.ptTail = NIL)
     then begin
        //   
        ptQueue^.ptHead:=ptWE;
        ptQueue^.ptTail:=ptWE;
     end
     else begin
       //    
       //   
       ptNE:=ptQueue^.ptHead;    //    
       ptNE^.ptPrev:=ptWE;       //      
       ptWE^.ptNext:=ptNE;       //      
       ptQueue^.ptHead:=ptWE;    //        head
     end;
     Inc(ptQueue^.QEKey);        // +1    
     Inc(ptQueue^.QECount);      // +1     
     ptWE^.Num:=ptQueue^.QEKey;  //    
     ptQueue^.ptCurr:=ptWE;      //    
   except
     ShowMessage('     ');
   end;
end;

// --------------------------------------------------------
//       
function CutQElement
  ( ptQueue  : TptTQueueRec;  //    
    Cmd      : char           //  'H' -   head, 'T'  tail 
  ) : pointer;                //     
var
    ptQEcut,
    ptQE     : TptTQElementRec;
begin
 Result  := nil;             //  
 ptQE    := nil;
 ptQEcut := nil;
 // ,    
 if (ptQueue^.ptHead <> nil) and (ptQueue^.ptTail <> nil)
 then begin
   //   
   case UpCase(Cmd) of
   'H': begin
      //     
      ptQEcut := ptQueue^.ptHead; //      
      ptQE := ptQEcut^.ptNext;    //     nil
      if (ptQE = nil)             // ptQEcut    ?
      then ptQueue^.ptTail := nil
      else ptQE^.ptPrev := nil;
       ptQueue^.ptHead := ptQE;    //    
   end;
   'T': begin
      //     
      ptQEcut := ptQueue^.ptTail; //      
      ptQE := ptQEcut^.ptPrev;    //     nil
      if (ptQE = nil)             // ptQEcut    ?
      then ptQueue^.ptHead := nil
      else ptQE^.ptNext := nil;
      ptQueue^.ptTail := ptQE;    //    
   end;
   end; // case
   ptQueue^.ptCurr := ptQE;
   if (ptQueue^.ptTail = nil) or (ptQueue^.ptHead = nil)
   then Fillchar(ptQueue^, SizeOF(ptQueue^),#0)  //   
   else Dec(ptQueue^.QECount);    //     
   Result := ptQEcut;             //    
 end;
end;

// --------------------------------------------------------
//    
procedure DelQElement
   (ptQueue : TptTQueueRec;  //    
    Cmd     : char           //  'H' -   Head, 'T'  Tail 
   );
var  ptQEdel : TptTQElementRec;
begin
  case UpCase(Cmd) of
  'H': ptQEdel:=ptQueue^.ptHead;
  'T': ptQEdel:=ptQueue^.ptTail;
  else ptQEdel:= nil
  end;
  if (ptQEdel <> nil)
  then begin
    if (ptQEdel^.ptObj = nil)
    then begin
      //     
      ptQEdel := CutQElement( ptQueue,Cmd);
      if (ptQEdel <> nil)
      then begin
        try
          Fillchar(ptQEdel^, SizeOF(ptQEdel^),#0);  // 
          Dispose(ptQEdel);    //   
        except
          ShowMessage('     ');
        end;
      end;
    end
    else ShowMessage('    .   .');
  end;
end;

// --------------------------------------------------------
//     (  )
function QueueNavigate (ptQueue : TptTQueueRec; Cmd : char): pointer;
var ptQE : TptTQElementRec;
begin
  Result := nil;
  ptQE := nil;
  if (ptQueue <> nil)
  then begin
    case UpCase(Cmd) of
    'H': ptQE := ptQueue^.ptHead;      //    
    'N': begin                         //    
           ptQE := ptQueue^.ptCurr;
           if ptQE <> nil
           then ptQE := ptQE^.ptNext
           else ptQE := nil;
         end;
    'P': begin                        //    
           ptQE := ptQueue^.ptCurr;
           if ptQE <> nil
           then ptQE := ptQE^.ptPrev
           else ptQE := nil;
         end;
    'T': ptQE := ptQueue^.ptTail;     //    
    end; // of case
    if ptQE <> nil
    then begin
      ptQueue^.ptCurr := ptQE;
      Result := ptQE;
    end;
  end; // of if
end;


// ========================================================
//   
// ========================================================
// --------------------------------------------------------
//      
procedure TForm1.bttAddClick(Sender: TObject);
var  ptQueue : TptTQueueRec;
     ptWE    : TptTQElementRec;
begin
   ptQueue := GetQueue();
   AddNewQElement(ptQueue, 'T');
   StaticText2.Caption := IntToStr(ptQueue^.QECount);
   ptWE := ptQueue^.ptCurr;
   StaticText3.Caption:=IntToStr(ptWE^.Num);
end;
// --------------------------------------------------------
//     
procedure TForm1.bttDelClick(Sender: TObject);
var  ptQueue : TptTQueueRec;
     ptWE    : TptTQElementRec;
begin
   ptQueue := GetQueue();
   DelQElement (ptQueue, 'T');
   StaticText2.Caption := IntToStr(ptQueue^.QECount);
   ptWE := ptQueue^.ptCurr;
   if ptWE <> nil
   then StaticText3.Caption:=IntToStr(ptWE^.Num)
   else StaticText3.Caption := '';
end;
// --------------------------------------------------------
//    
procedure TForm1.bttNextClick(Sender: TObject);
var   ptWE   : TptTQElementRec;
begin
   ptWE := QueueNavigate(GetQueue(),'N');
   if ptWE <> nil
   then StaticText3.Caption := IntToStr(ptWE^.Num);
end;
// --------------------------------------------------------
//    
procedure TForm1.bttPrevClick(Sender: TObject);
var   ptWE   : TptTQElementRec;
begin
   ptWE := QueueNavigate(GetQueue(),'P');
   if ptWE <> nil
   then StaticText3.Caption := IntToStr(ptWE^.Num);
end;
// --------------------------------------------------------
//    
procedure TForm1.bttToBeginClick(Sender: TObject);
var   ptWE   : TptTQElementRec;
begin
   ptWE := QueueNavigate(GetQueue(),'H');
   if ptWE <> nil
   then StaticText3.Caption := IntToStr(ptWE^.Num);
end;
// --------------------------------------------------------
//    
procedure TForm1.bttToEndClick(Sender: TObject);
var   ptWE   : TptTQElementRec;
begin
  ptWE := QueueNavigate(GetQueue(),'T');
   if ptWE <> nil
   then StaticText3.Caption := IntToStr(ptWE^.Num);
end;
// --------------------------------------------------------


end.
